//=============================================================================
//
//
//
//
//
//=============================================================================
#define		ORBITER_MODULE
#include	"math.h"
#include	"orbitersdk.h"
#include	"stdio.h"
#include	"soyuz_shute_door.h"

HINSTANCE	h_DLL;

const		double		EMPTY_MASS = 20;

const		VECTOR3		TP1 = {0.0, -1.0, -0.02};
const		VECTOR3		TP2 = {-cos(30*RAD), sin(30*RAD), -0.02};
const		VECTOR3		TP3 = {cos(30*RAD), sin(30*RAD), -0.02};

const		VECTOR3		SC_REF = {0, -0.01, -0.14};
const		VECTOR3		SC_DIR = {0, 0, -1};
const		VECTOR3		SC_ROT = {1, 0, 0};

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK	void InitModule(HINSTANCE hModule)
{
	h_DLL = hModule;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DLLCLBK void ExitModule(HINSTANCE hModule)
{

}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
soyuz_shute_door::soyuz_shute_door(OBJHANDLE hObj, int fmodel): VESSEL2(hObj, fmodel)
{
	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkLoadStateEx(FILEHANDLE scn, void *status)
{
	char *line;

	while (oapiReadScenario_nextline(scn, line))
	{
		if (!strnicmp (line, "MESHNAME", 8))
		{
			sscanf (line+8, "%s", &MeshName);
		}

		ParseScenarioLineEx(line, status);
	}

	hsoyuz_shute_door = oapiLoadMeshGlobal(MeshName);
	AddMesh(hsoyuz_shute_door);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkSaveState(FILEHANDLE scn)
{
	VESSEL2::clbkSaveState(scn);
	oapiWriteScenario_string(scn, "MESHNAME", MeshName);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkSetClassCaps(FILEHANDLE cfg)
{
	SetSize(1.0);
	SetEmptyMass(EMPTY_MASS);
	SetSurfaceFrictionCoeff(1e5, 1e5);
	SetTouchdownPoints(TP1, TP2, TP3);

	hCapsule = CreateAttachment(true,
			 				    SC_REF,
								SC_DIR,
								SC_ROT,
								"Capsule",
								false);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkPostStep(double simt, double SimDT, double mjd)
{
	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkVisualCreated(VISHANDLE visual, int refcount)
{
	if (refcount > 1) return;
	vis = visual;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void soyuz_shute_door::clbkVisualDestroyed(VISHANDLE visual, int refcount)
{
	if (visual == vis) vis = NULL;
}


//=============================================================================
//
//=============================================================================
DLLCLBK VESSEL *ovcInit(OBJHANDLE hvessel, int flightmodel)
{
	return new soyuz_shute_door(hvessel, flightmodel);
}

DLLCLBK void ovcExit(VESSEL *vessel)
{
	if (vessel) delete (soyuz_shute_door*) vessel;
}



